# ICE Conversation Starter

Use this at the start of any AI conversation to invoke the ICE approach. Works with ChatGPT, Claude, Gemini, Copilot, and other AI assistants.

---

## How to Use

1. Copy the prompt below
2. Paste it at the start of a new conversation with any AI
3. Then describe your task
4. The AI will guide you through ICE before implementing

---

## The Prompt

Copy everything between the lines:

---

Before we start working on my task, I'd like you to help me think it through using the ICE framework:

**Intent:** Ask me what I'm trying to achieve and why. Help me articulate the problem I'm solving, who it's for, and what context matters. Don't assume you understand — ask clarifying questions until the intent is clear.

**Constraints:** Help me surface the boundaries. What technical limitations exist? What business rules apply? What can we NOT do? What resources are limited? Ask questions to uncover constraints I might not have stated.

**Expectations:** Help me define how we'll know it's successful. What does "right" look like? What will the user experience? What should happen when things go wrong? What edge cases exist?

**Critical Review:** Before we implement anything, adopt the perspective of a sceptical user or critic. What have we missed? What could go wrong? What assumptions might be wrong?

**Blueprint:** Once we've worked through ICE, summarise what we've agreed so I have a reference document.

Here's my task: [describe your task here]

---

## Example Usage

### Starting a conversation:

> Before we start working on my task, I'd like you to help me think it through using the ICE framework:
>
> [paste the full ICE prompt above]
>
> Here's my task: I need to add a settings panel to my web application.

### The AI will respond with questions like:

> Let me help you think through this using ICE.
>
> **Intent:** What problem does this settings panel solve for your users? What will they be able to configure? Are they currently unable to customise something, or is this about making existing options more accessible?

### You answer, and the dialogue continues through Constraints, Expectations, and Critical Review.

---

## Mid-Conversation Reminder

If the AI starts implementing without asking questions, you can redirect:

> Hold on — let's apply ICE first. What questions do you have about intent, constraints, and expectations before we start building?

---

## Quick Version

For simpler tasks, use this shorter prompt:

> Before implementing: Ask me about Intent (what and why), Constraints (boundaries and limits), and Expectations (how we verify success). Challenge any unclear requirements. What questions do you have?

---

## Tips for Better Results

1. **Answer thoroughly** — The more context you provide, the better the output
2. **Don't skip the critical review** — This catches problems before they're built
3. **Save the blueprint** — Copy the summary for future reference
4. **Iterate** — If something isn't working, identify which ICE element shifted and re-run that part

---

*From the ICE Framework, part of "Vibe-Coding: The Art of Collaborating with AI" by Mark C. Turner*
*Learn more at interloquial.com*
